#include "graph_tga.h"

graph_tga::graph_tga()
{
	size_x = -1;
	size_y = -1;
}

graph_tga::~graph_tga()
{
	if ((size_x > -1) && (size_y > -1)) {
		delete[] coord_array;
	}
}

void graph_tga::build_graph(int in_size_x, int in_size_y)
{
	size_x = in_size_x;
	size_y = in_size_y;
	coord_array = new unsigned char[(size_x)*(size_y)*3+1];
	for (int i = 0; i < size_x*size_y*3; i++) {
		coord_array[i] = 0;
	}
}

void graph_tga::write_graph(char *pathstr)
{
	int log = _open (pathstr, _O_BINARY | _O_CREAT | _O_TRUNC | _O_WRONLY, _S_IWRITE);
	_write (log, "\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00", 12);
	char tempstr[5];
	tempstr[0] = (unsigned char) (size_x % 256); 
	tempstr[1] = (unsigned char) (size_x / 256);
	tempstr[2] = (unsigned char) (size_y % 256);
	tempstr[3] = (unsigned char) (size_y / 256); 
	tempstr[4] = 0;
	_write (log, tempstr, 4); 
	_write (log, "\x18\x00", 2);
	_write (log, coord_array, size_x*size_y*3);
	close (log);
}

void graph_tga::draw_pixel_abs(int x_pos, int y_pos, int color_r, int color_g, int color_b)
{
	if ((x_pos >= size_x) || (x_pos < 0)) {
		printf ("\nWARNING: x coordinate overflow: %i/%i (please report this!)", x_pos, size_x);
		x_pos = size_x-1;
		return;
	}
	if ((y_pos >= size_y) || (y_pos < 0)) {
		printf ("\nWARNING: y coordinate overflow: %i/%i (please report this!)", y_pos, size_y);
		y_pos = size_y-1;
		return;
	}
	coord_array[(y_pos*size_x+x_pos)*3+0] = color_b;
	coord_array[(y_pos*size_x+x_pos)*3+1] = color_g;
	coord_array[(y_pos*size_x+x_pos)*3+2] = color_r;
}

void graph_tga::draw_pixel_rel(double x_pos, double y_pos, int color_r, int color_g, int color_b)
{
	int int_x = (int) (x_pos * (size_x-1));
	int int_y = (int) (y_pos * (size_y-1));
	draw_pixel_abs (int_x, int_y, color_r, color_g, color_b);
}

void graph_tga::draw_line_abs(int start_x, int start_y, int end_x, int end_y, int color_r, int color_g, int color_b)
{
	double dx = end_x - start_x;
	double dy = end_y - start_y;
	double m = dy/dx;
	if ((m > -1) && (m < 1)) {
		double y = start_y + 0.5;
		for (int x = start_x; x <= end_x; x++) {
			draw_pixel_abs (x, (int) y, color_r, color_g, color_b);
			y += m;
			// if line should be thicker -> add pixel(s) above and below
		}
	} else {
		m = dx/dy;
		double x = start_x + 0.5;
		for (int y = start_y; y <= end_y; y++) {
			draw_pixel_abs ((int) x, y, color_r, color_g, color_b);
			x += m;
			// if line should be thicker -> add pixel(s) above and below
		}
	}
}

void graph_tga::draw_line_rel(double start_x, double start_y, double end_x, double end_y, int color_r, int color_g, int color_b)
{
	int int_start_x = (int) (start_x * (size_x-1));
	int int_start_y = (int) (start_y * (size_y-1));
	int int_end_x = (int) (end_x * (size_x-1));
	int int_end_y = (int) (end_y * (size_y-1));
	draw_line_abs (int_start_x, int_start_y, int_end_x, int_end_y, color_r, color_g, color_b);
}

void graph_tga::draw_circle_filled_rel(double x_pos, double y_pos, int radius, int color_r, int color_g, int color_b)
{
	int int_x = (int) (x_pos * (size_x-1));
	int int_y = (int) (y_pos * (size_y-1));
	draw_circle_filled_abs (int_x, int_y, radius, color_r, color_g, color_b);	
}

void graph_tga::draw_circle_filled_abs(int x_pos, int y_pos, int radius, int color_r, int color_g, int color_b)
{
	//-- check if circle excesses image boundaries
	draw_pixel_abs (x_pos, y_pos, color_r, color_g, color_b); // middle pixel
	for (int y = y_pos - radius; y < y_pos + radius; y++) {
		for (int x = x_pos - radius; x < x_pos + radius; x++) {
			if (get_distance (x, y, x_pos, y_pos) <= radius) {
				draw_pixel_abs (x, y, color_r, color_g, color_b); // upper left pixel 
				draw_pixel_abs (x_pos+(x_pos-x), y, color_r, color_g, color_b); // upper right pixel
				draw_pixel_abs (x, y_pos+(y_pos-y), color_r, color_g, color_b); // lower left pixel
				draw_pixel_abs (x_pos+(x_pos-x), y_pos+(y_pos-y), color_r, color_g, color_b); // lower right pixel
			}
		}
	}
}

int graph_tga::get_distance(int start_x, int start_y, int end_x, int end_y)
{
	double d = (end_x - start_x) * (end_x - start_x);
	d += (end_y - start_y) * (end_y - start_y);
	return (int) (sqrt(d) + 0.5);
}
